ORCA/M Asm65816 2.1.0

0001 CF28                       title 'Desk Manager--CDAMenu'
0002 CF28              **********************************************************************
0003 CF28              *
0004 CF28              * Desk Manager--CDAMenu for the Apple II GS
0005 CF28              *
0006 CF28              * Original CDA code by John Worthinton.
0007 CF28              * Original NDA code by Steven Glass
0008 CF28              *
0009 CF28              * Additions and alterations by Steven Glass and
0010 CF28              * Konstantin Othmer
0011 CF28              *
0012 CF28              * This file contains all the code necessary to handle the CDA menu.
0013 CF28              *
0014 CF28              * The procedures in this file are:
0015 CF28              *
0016 CF28              *                   DAHandler
0017 CF28              *                   DoCDAMenu
0018 CF28              *                   DisplayData
0019 CF28              *                   SortCDAs
0020 CF28              *                   ChooseCDA
0021 CF28              *                   InitStuff
0022 CF28              *                   GotReturn
0023 CF28              *                   MonKeyIn
0024 CF28              *                   EvntKeyIn
0025 CF28              *                   Pg2Kludge
0026 CF28              *                   UpdateCDAMenu
0027 CF28              *                   PrintDAList
0028 CF28              *                   WriteDAName
0029 CF28              *                   SetUpTab
0030 CF28              *                   OpenDA
0031 CF28              *                   Deref*
0032 CF28              *
0033 CF28              **********************************************************************
0034 CF28
0035 CF28              **********************************************************************
0036 CF28              *                                                                    *
0037 CF28              *                   Copyright (C) 1985-1991                          *
0038 CF28              *                   Apple Computer, Inc.                             *
0039 CF28              *                   All Rights Reserved                              *
0040 CF28              *                                                                    *
0041 CF28              **********************************************************************
0042 CF28
0043 CF28                       msb ON 
0044 CF28
0045 CF28                       include 'all.macros' 
0046 CF28                       include '::sys.equs.asm' 
0047 CF28                       include 'e16.memory' 
0048 CF28
0049 CF28
0050 CF28              DAVersionNumber equ $8301               ;8300
0051 CF28
0052 CF28              Slot_Arbiter equ $E10208 
0053 CF28
0054 CF28                       include 'Desk.Equates.asm' 
0055 CF28
0056 CF28
0057 CF28                       title 'CDAMenu--DAhandler' 
0058 CF28              ****************************************************************
0059 CF28              *
0060 CF28              DAHandler PROC EXPORT 
0061 CF28              *
0062 CF28              * This is the code that handles Desk Accessory interrupts.
0063 CF28              * When a CDA interrupt occurs, this handler gets control
0064 CF28              * in 8-bit native mode.  It decides whether actually put
0065 CF28              * up the CDA menu or schedule an event.
0066 CF28              *
0067 CF28              * Note that this handler does not get called if the EventManger
0068 CF28              * is active.  In that case, the Event Manager installs its own
0069 CF28              * interrupt handler whose job it is to post events.
0070 CF28              *
0071 CF28              *
0072 CF28              * Inputs:
0073 CF28              *                   none
0074 CF28              *
0075 CF28              * Outputs:
0076 CF28              *                   carry clear indicates that interrupt
0077 CF28              *                   is handled.
0078 CF28              *
0079 CF28              * External Refs:
0080 CF28                       import DoCDAMenu 
0081 CF28              *
0082 CF28              * Entry Points:
0083 CF28              *                   none
0084 CF28              *
0085 CF28                       longa off                      ; mode
0086 CF28                       longi off
0087 CF28              *
0088 CF28              * Change History
0089 CF28              *
0090 CF28              * 19 Jul 88         Steven Glass
0091 CF28              *
0092 CF28              * This code used to be part of the procedure DABootInit.  It is
0093 CF28              * now separate and more self contained.  
0094 CF28              *
0095 CF28              ****************************************************************
0096 CF28
0097 CF28 08                    php                            ; save status register
0098 CF29
0099 CF29              ;-----------------------------------------------------------
0100 CF29              ;
0101 CF29              ; Check the global variable NumInts.  If this number is
0102 CF29              ; is negative, we aren't alread in the CDA menu.  This
0103 CF29              ; prevents multiple entries into the CDA menu.
0104 CF29              ;
0105 CF29 AF 67 1D E0           lda   >numints
0106 CF2D 1A                    inc   a
0107 CF2E D0 25                 bne   AllDone
0108 CF30
0109 CF30
0110 CF30              ;-----------------------------------------------------------
0111 CF30              ;
0112 CF30              ; Check the busy flag.  If it is not zero, we schedule
0113 CF30              ; an interrupt.  If it is zero, we go ahead now.
0114 CF30              ;
0115 CF30 AF FF 00 E1           lda   >busyflag                ; if busyflg is 0 then we can
0116 CF34 D0 06                 bne   ScheduleIt
0117 CF36
0118 CF36 22 58 CF FE           jsl   DoCDAMenu
0119 CF3A 80 19                 bra   AllDone
0120 CF3C
0121 CF3C C2 30        ScheduleIt longmx                       ; switch to full native to make call
0122 CF3E 48                    pha                            ; space for result
0123 CF3F F4 FE 00 F4           PushLong #DoCDAMenu            ; get in the scheduler's que
0124 CF45 A2 07 09 22           _SchAddTask 
0125 CF4C 68                    pla                            ; ignore result
0126 CF4D
0127 CF4D E2 30                 shortmx                        ; switch back to 8-bit native
0128 CF4F
0129 CF4F A9 FF                 lda   #$FF                     ; reset the NumInts variable
0130 CF51 8F 67 1D E0           sta   >numints
0131 CF55
0132 CF55 28           AllDone  plp                            ; restore P
0133 CF56 18                    clc                            ; claim the interrupt
0134 CF57 6B                    rtl                            ; all done.
0135 CF58
0136 CF58
0137 CF58                       ENDP 
0138 CF58
0139 CF58                       title 'CDAMenu--DoCDAMenu'
0140 CF58              ****************************************************************
0141 CF58              *
0142 CF58              DoCDAMenu PROC 
0143 CF58              *
0144 CF58              * This is the routine that is called to display the CDA
0145 CF58              * menu.  It is either called by the DA interrupt handler
0146 CF58              * (if it is safe to do so) or by the scheduler.
0147 CF58              *
0148 CF58              * This code can be called in either 8, or 16 bit native
0149 CF58              * mode and should work fine.
0150 CF58              *
0151 CF58              * This code resets the variable NumInts to $FF and it sets
0152 CF58              * the next byte after it (mmode) to zero.  Why it does this
0153 CF58              * is not really know, but must accesses to NumInts seem
0154 CF58              * to trash mmode.
0155 CF58              *
0156 CF58              *
0157 CF58              * Inputs:
0158 CF58              *                   none
0159 CF58              *
0160 CF58              * Outputs:
0161 CF58              *                   none
0162 CF58              *
0163 CF58              * External Refs:
0164 CF58              *                   none
0165 CF58              *
0166 CF58              * Entry Points:
0167 CF58              *                   none
0168 CF58              *
0169 CF58                       longa on                       ; mode
0170 CF58                       longi on
0171 CF58              *
0172 CF58              * Change History
0173 CF58              *
0174 CF58              * 19 Jul 88         Steven Glass
0175 CF58              *
0176 CF58              * This code used to be part of the procedure DABootInit.  It is
0177 CF58              * now separate and more self contained.  The same code is called
0178 CF58              * in the same way whether or not the scheduler is used.
0179 CF58              *
0180 CF58              * This code used to save and restore the dbr around the 
0181 CF58              * code that moved the stack.  Instead, we save and restore the dbr at
0182 CF58              * the same time as the processor.
0183 CF58              *
0184 CF58              ****************************************************************
0185 CF58
0186 CF58 08                    php                            ; save m&x bits
0187 CF59 8B                    phb                            ; save dbr
0188 CF5A C2 30                 longmx                         ; now in full native mode.
0189 CF5C
0190 CF5C 3B                    tsc                            ; save stack for integer basic
0191 CF5D 8F 9C 1D E0           sta   >stacksv
0192 CF61
0193 CF61              ; Save stack but don't worry about changing data bank.
0194 CF61              ; it is saved above and restored below with P.
0195 CF61              ;
0196 CF61 A2 00 01              ldx   #$0100                   ; stack is saved as $E0/0300
0197 CF64 A0 00 03              ldy   #$0300
0198 CF67 A9 FF 00              lda   #$FF
0199 CF6A 54 E0 00              mvn   $000000,$E00000
0200 CF6D
0201 CF6D A9 FB 01              lda   #$1FB                    ; make sure there's room on stack
0202 CF70 1B                    tcs   
0203 CF71
0204 CF71 A2 05 0B 22           _SaveAll                       ; save everything
0205 CF78 A2 05 11 22           _ChooseCDA                     ; display the list of da's
0206 CF7F A2 05 0C 22           _RestAll                       ; unsave everything
0207 CF86
0208 CF86
0209 CF86 A9 FF 00              lda   #$FF                     ; clear numints on exit
0210 CF89 8F 67 1D E0           sta   >numints                 ; trash next byte too!!!!!!!!!!!!!!
0211 CF8D
0212 CF8D A2 00 03              ldx   #$0300                   ; move stack from buffer back to 
0213 CF90 A0 00 01              ldy   #$0100                   ; page 1.
0214 CF93 A9 FF 00              lda   #$FF
0215 CF96 54 00 E0              mvn   $E00000,$000000
0216 CF99
0217 CF99 AF 9C 1D E0           lda   >stacksv                 ; restore stack pointer.
0218 CF9D 1B                    tcs   
0219 CF9E
0220 CF9E AB                    plb                            ; restore dbr
0221 CF9F 28                    plp                            ; restore m & x bits.
0222 CFA0 6B                    rtl   
0223 CFA1
0224 CFA1
0225 CFA1                       ENDP 
0226 CFA1
0227 CFA1
0228 CFA1
0229 CFA1                       title 'CDAMenu--DisplayData'
0230 CFA1              displaydata PROC EXPORT 
0231 CFA1
0232 CFA1
0233 CFA1                       EXPORT topofmenu
0234 CFA1 A0           topofmenu DC B:$A0
0235 CFA2 DF                    DC B:$DF
0236 CFA3 DF                    DC B:$DF
0237 CFA4 DF                    DC B:$DF
0238 CFA5 DF                    DC B:$DF
0239 CFA6 DF                    DC B:$DF
0240 CFA7 DF                    DC B:$DF
0241 CFA8 DF                    DC B:$DF
0242 CFA9 DF                    DC B:$DF
0243 CFAA DF                    DC B:$DF
0244 CFAB DF                    DC B:$DF
0245 CFAC DF                    DC B:$DF
0246 CFAD DF                    DC B:$DF
0247 CFAE DF                    DC B:$DF
0248 CFAF DF                    DC B:$DF
0249 CFB0 DF                    DC B:$DF
0250 CFB1 DF                    DC B:$DF
0251 CFB2 DF                    DC B:$DF
0252 CFB3 DF                    DC B:$DF
0253 CFB4 DF                    DC B:$DF
0254 CFB5 DF                    DC B:$DF
0255 CFB6 DF                    DC B:$DF
0256 CFB7 DF                    DC B:$DF
0257 CFB8 DF                    DC B:$DF
0258 CFB9 DF                    DC B:$DF
0259 CFBA DF                    DC B:$DF
0260 CFBB DF                    DC B:$DF
0261 CFBC DF                    DC B:$DF
0262 CFBD DF                    DC B:$DF
0263 CFBE DF                    DC B:$DF
0264 CFBF DF                    DC B:$DF
0265 CFC0 DF                    DC B:$DF
0266 CFC1 DF                    DC B:$DF
0267 CFC2 DF                    DC B:$DF
0268 CFC3 DF                    DC B:$DF
0269 CFC4 DF                    DC B:$DF
0270 CFC5 DF                    DC B:$DF
0271 CFC6 DF                    DC B:$DF
0272 CFC7 DF                    DC B:$DF
0273 CFC8 A0 00                 DC B:$A0,$00
0274 CFCA
0275 CFCA                       EXPORT mainstr
0276 CFCA 5A A0 41 A0  mainstr  DC B:$5A,$A0,$41,$A0
0277 CFCE C4 E5 F3 EB           DC B:'Desk Accessories '
0278 CFDF 20                    DC B:$20
0279 CFE0 20                    DC B:$20
0280 CFE1 20                    DC B:$20
0281 CFE2 20                    DC B:$20
0282 CFE3 20                    DC B:$20
0283 CFE4 20                    DC B:$20
0284 CFE5 20                    DC B:$20
0285 CFE6 20                    DC B:$20
0286 CFE7 20                    DC B:$20
0287 CFE8 20                    DC B:$20
0288 CFE9 20                    DC B:$20
0289 CFEA 20                    DC B:$20
0290 CFEB 20                    DC B:$20
0291 CFEC 20                    DC B:$20
0292 CFED 20                    DC B:$20
0293 CFEE 20                    DC B:$20
0294 CFEF 20                    DC B:$20
0295 CFF0 20                    DC B:$20
0296 CFF1 5F 00                 DC B:$5F,$00
0297 CFF3
0298 CFF3                       EXPORT bottmofmenu
0299 CFF3 5A           bottmofmenu DC B:$5A
0300 CFF4 4C                    DC B:$4C
0301 CFF5 4C                    DC B:$4C
0302 CFF6 4C                    DC B:$4C
0303 CFF7 4C                    DC B:$4C
0304 CFF8 4C                    DC B:$4C
0305 CFF9 4C                    DC B:$4C
0306 CFFA 4C                    DC B:$4C
0307 CFFB 4C                    DC B:$4C
0308 CFFC 4C                    DC B:$4C
0309 CFFD 4C                    DC B:$4C
0310 CFFE 4C                    DC B:$4C
0311 CFFF 4C                    DC B:$4C
0312 D000 4C                    DC B:$4C
0313 D001 4C                    DC B:$4C
0314 D002 4C                    DC B:$4C
0315 D003 4C                    DC B:$4C
0316 D004 4C                    DC B:$4C
0317 D005 4C                    DC B:$4C
0318 D006 4C                    DC B:$4C
0319 D007 4C                    DC B:$4C
0320 D008 4C                    DC B:$4C
0321 D009 4C                    DC B:$4C
0322 D00A 4C                    DC B:$4C
0323 D00B 4C                    DC B:$4C
0324 D00C 4C                    DC B:$4C
0325 D00D 4C                    DC B:$4C
0326 D00E 4C                    DC B:$4C
0327 D00F 4C                    DC B:$4C
0328 D010 4C                    DC B:$4C
0329 D011 4C                    DC B:$4C
0330 D012 4C                    DC B:$4C
0331 D013 4C                    DC B:$4C
0332 D014 4C                    DC B:$4C
0333 D015 4C                    DC B:$4C
0334 D016 4C                    DC B:$4C
0335 D017 4C                    DC B:$4C
0336 D018 4C                    DC B:$4C
0337 D019 4C                    DC B:$4C
0338 D01A 5F 00                 DC B:$5F,$00
0339 D01C
0340 D01C              ;	EXPORT	midstr
0341 D01C              ;midstr	DC.B	$5A
0342 D01C              ;	DC.B	$FF,$24,$A0
0343 D01C              ;	DC.B	$5F,$00
0344 D01C
0345 D01C                       EXPORT selectstr
0346 D01C 5A           selectstr DC B:$5A
0347 D01D A0 D3 E5 EC           DC B:' Select: '
0348 D026 4A A0 4B              DC B:$4A,$A0,$4B
0349 D029 A0                    DC B:$A0
0350 D02A A0                    DC B:$A0
0351 D02B A0                    DC B:$A0
0352 D02C A0                    DC B:$A0
0353 D02D A0                    DC B:$A0
0354 D02E A0                    DC B:$A0
0355 D02F A0                    DC B:$A0
0356 D030 A0                    DC B:$A0
0357 D031 A0                    DC B:$A0
0358 D032 A0                    DC B:$A0
0359 D033 A0                    DC B:$A0
0360 D034 A0                    DC B:$A0
0361 D035 A0                    DC B:$A0
0362 D036 A0                    DC B:$A0
0363 D037 A0                    DC B:$A0
0364 D038 A0                    DC B:$A0
0365 D039 A0                    DC B:$A0
0366 D03A CF F0 E5 EE           DC B:'Open: '
0367 D040 4D A0 A0 5F           DC B:$4D,$A0,$A0,$5F,$00
0368 D045
0369 D045                       EXPORT laststr
0370 D045 A0           laststr  DC B:$A0
0371 D046 4C                    DC B:$4C
0372 D047 4C                    DC B:$4C
0373 D048 4C                    DC B:$4C
0374 D049 4C                    DC B:$4C
0375 D04A 4C                    DC B:$4C
0376 D04B 4C                    DC B:$4C
0377 D04C 4C                    DC B:$4C
0378 D04D 4C                    DC B:$4C
0379 D04E 4C                    DC B:$4C
0380 D04F 4C                    DC B:$4C
0381 D050 4C                    DC B:$4C
0382 D051 4C                    DC B:$4C
0383 D052 4C                    DC B:$4C
0384 D053 4C                    DC B:$4C
0385 D054 4C                    DC B:$4C
0386 D055 4C                    DC B:$4C
0387 D056 4C                    DC B:$4C
0388 D057 4C                    DC B:$4C
0389 D058 4C                    DC B:$4C
0390 D059 4C                    DC B:$4C
0391 D05A 4C                    DC B:$4C
0392 D05B 4C                    DC B:$4C
0393 D05C 4C                    DC B:$4C
0394 D05D 4C                    DC B:$4C
0395 D05E 4C                    DC B:$4C
0396 D05F 4C                    DC B:$4C
0397 D060 4C                    DC B:$4C
0398 D061 4C                    DC B:$4C
0399 D062 4C                    DC B:$4C
0400 D063 4C                    DC B:$4C
0401 D064 4C                    DC B:$4C
0402 D065 4C                    DC B:$4C
0403 D066 4C                    DC B:$4C
0404 D067 4C                    DC B:$4C
0405 D068 4C                    DC B:$4C
0406 D069 4C                    DC B:$4C
0407 D06A 4C                    DC B:$4C
0408 D06B 4C                    DC B:$4C
0409 D06C 00                    DC B:$00
0410 D06D
0411 D06D                       EXPORT uparrows
0412 D06D              uparrows  
0413 D06D 5B 5B 5B A0           DC B:$5B,$5B,$5B,$A0,'more',$A0,$5B,$5B,$5B ;up arrows are 4B
0414 D079 00                    DC B:$00
0415 D07A                       EXPORT downarrows
0416 D07A 5B 5B 5B A0  downarrows DC B:$5B,$5B,$5B,$A0,'more',$A0,$5B,$5B,$5B ;down arrows are 4A
0417 D086 00                    DC B:$00
0418 D087
0419 D087                       EXPORT blankline
0420 D087 A0 A0 A0 A0  blankline DC B:'                                    '
0421 D0AB 00                    DC B:$00
0422 D0AC
0423 D0AC
0424 D0AC                       EXPORT dastr
0425 D0AC CA CF FE 00  dastr    DC L:mainstr
0426 D0B0 BC D0 FE 00           DC L:cntrlstr
0427 D0B4 CA D0 FE 00           DC L:quitstr
0428 D0B8 1C D0 FE 00           DC L:selectstr
0429 D0BC
0430 D0BC                       EXPORT cntrlstr
0431 D0BC C3 EF EE F4  cntrlstr DC B:'Control Panel'
0432 D0C9 00                    DC B:$00
0433 D0CA
0434 D0CA                       EXPORT quitstr
0435 D0CA D1 F5 E9 F4  quitstr  DC B:'Quit'
0436 D0CE 00                    DC B:$00
0437 D0CF
0438 D0CF
0439 D0CF                       ENDP 
0440 D0CF
0441 D0CF
0442 D0CF              ****************************************************************
0443 D0CF              *
0444 D0CF              ChooseCDA PROC EXPORT 
0445 D0CF              *
0446 D0CF              * ChooseCDA is the internal routine that causes the CDA menu
0447 D0CF              * to be displayed.
0448 D0CF              *
0449 D0CF              * The system must already be in text mode before this call is
0450 D0CF              * made.  This call assumes that stack and d-page are already
0451 D0CF              * set to page 1 and page 0.
0452 D0CF              *
0453 D0CF              *
0454 D0CF              * Inputs:
0455 D0CF              *                   none
0456 D0CF              *
0457 D0CF              * Outputs:
0458 D0CF              *                   none
0459 D0CF              *
0460 D0CF              * External Refs:
0461 D0CF              *                   none
0462 D0CF              *
0463 D0CF              * Entry Points:
0464 D0CF              *                   none
0465 D0CF              *
0466 D0CF                       longa on                       ; mode
0467 D0CF                       longi on
0468 D0CF              *
0469 D0CF              *
0470 D0CF              * Change History:
0471 D0CF              *
0472 D0CF              *  Halloween        Kontstantin Othmer
0473 D0CF              *
0474 D0CF              *   Added warm entry point so that current state of desk manager
0475 D0CF              * is saved and returned to after the cda call is done.
0476 D0CF              * Also took out all the brks.
0477 D0CF              *
0478 D0CF              ****************************************************************
0479 D0CF
0480 D0CF 8B                    phb                            ; save dbr
0481 D0D0
0482 D0D0 A9 00 00              lda   #0
0483 D0D3 8F 80 1D E0           sta   >firstMenuItem           ; tell UpdateCDA to start at item 0
0484 D0D7 8F B0 1D E0           sta   >curCDA                  ; select item 0 (control panel)
0485 D0DB
0486 D0DB A9 03 00              lda   #$0003                   ;request current bit encoded configuration
0487 D0DE 22 08 02 E1           jsl   Slot_Arbiter             ;and make slot 3 internal
0488 D0E2 DA                    phx                            ;saves bit encoded configuration
0489 D0E3
0490 D0E3
0491 D0E3                       ENTRY ChooseCDAWarm 
0492 D0E3              ChooseCDAWarm  
0493 D0E3
0494 D0E3 F4 E0 E0              pea   $E0E0                    ;Reset dbr to bank $E0
0495 D0E6 AB                    plb   
0496 D0E7 AB                    plb   
0497 D0E8              SkipWarm  
0498 D0E8 20 25 D4              jsr   initstuff                ;This inits all formatting parameters
0499 D0EB
0500 D0EB F4 FF 00              pea   $FF                      ; and mask
0501 D0EE F4 00 00              pea   $00                      ; or mask
0502 D0F1 A2 0C 0A 22           _SetOutGlobals 
0503 D0F8
0504 D0F8 F4 00 00              pea   00                       ; device type
0505 D0FB F4 00 00 F4           pushlong #$03                  ; pointer to driver
0506 D101 A2 0C 10 22           _SetOutputDevice 
0507 D108
0508 D108              *
0509 D108              * Determine whether or not we have an 80 column card
0510 D108              *  Later we will use this information for setting the position of the menu
0511 D108              *  In 40 column mode, the menu starts in column 0
0512 D108              *  In 80 column mode, the menu starts in column 20
0513 D108              *
0514 D108 E2 30        loop13   shortmx 
0515 D10A A2 00                 ldx   #$00                     ; check for 80-col card in place
0516 D10C AD 05 C3     loop4card lda   $C305
0517 D10F C9 38                 cmp   #$38
0518 D111 D0 0C                 bne   nocard
0519 D113 AD 07 C3              lda   $C307
0520 D116 C9 18                 cmp   #$18
0521 D118 D0 05                 bne   nocard
0522 D11A E8                    inx   
0523 D11B D0 EF                 bne   loop4card
0524 D11D 80 05                 bra   cz2
0525 D11F
0526 D11F 8D 0A C0     nocard   sta   |setintc3rom             ; just to make sure its really in
0527 D122 80 E8                 bra   loop4card
0528 D124
0529 D124 A9 FF        cz2      lda   #$FF
0530 D126 8F 32 00 00           sta   >$000032                 ; turn off inverse
0531 D12A C2 30                 longmx 
0532 D12C F4 01 00              pea   01                       ; init device to output
0533 D12F A2 0C 15 22           _InitTextDev 
0534 D136
0535 D136 F4 00 00     cz3      PushWord #00 
0536 D139 F4 19 00              PushWord #$19                  ; want 40 cols
0537 D13C A2 03 0C 22           _ReadBParam 
0538 D143 68                    pla   
0539 D144 29 FF 00              and   #$00FF
0540 D147 8D 66 1D              sta   |sv4080
0541 D14A D0 1E                 bne   c1                       ;not 40 column; everything is ok
0542 D14C
0543 D14C              ; From here to c1 is 40 column init.
0544 D14C              ; Initstuff assumes 80 columns.
0545 D14C              ; The only difference is the position of the left border
0546 D14C
0547 D14C A9 11 00              lda   #$11                     ;Special 40 column init stuff
0548 D14F 20 7D D6              jsr   cout
0549 D152
0550 D152 E2 20                 sep   #$20
0551 D154 8F 00 C0 00           sta   >$00C000
0552 D158 8F 0C C0 00           sta   >$00C00C
0553 D15C C2 20                 rep   #$20
0554 D15E A9 03 00              lda   #LeftBorder40            ;Only difference between 80 & 40 is left
0555 D161 8D 7E 1D              sta   |leftborder              ;column starting location
0556 D164 A9 00 00              lda   #LeftBorder40-3
0557 D167 8D 72 1D              sta   |hpos                    ;menu border starts two to the left of text
0558 D16A
0559 D16A              c1         
0560 D16A A9 CF FE              lda   #>topofmenu
0561 D16D 85 41                 sta   temp2+1
0562 D16F A9 A1 CF              lda   #<topofmenu
0563 D172 85 40                 sta   temp2
0564 D174 20 A5 D7              jsr   mywritecstringnt
0565 D177 EE 74 1D              inc   |vpos
0566 D17A AD AC 1D              lda   |dastrptr                ; mainstr for international
0567 D17D 85 3C                 sta   temp1
0568 D17F AD AE 1D              lda   |dastrptr+2
0569 D182 85 3E                 sta   temp1+2
0570 D184 A0 02 00              ldy   #$02
0571 D187 B7 3C                 lda   [temp1],y
0572 D189 85 42                 sta   temp2+2
0573 D18B A7 3C                 lda   [temp1]
0574 D18D 85 40                 sta   temp2
0575 D18F 20 A5 D7              jsr   MyWriteCStringnt         ;Draws the Desk Accessories line
0576 D192 EE 74 1D              inc   |vpos
0577 D195 A9 CF FE              lda   #>bottmofmenu
0578 D198 85 41                 sta   temp2+1
0579 D19A A9 F3 CF              lda   #<bottmofmenu
0580 D19D 85 40                 sta   temp2
0581 D19F 20 A5 D7              jsr   MyWriteCStringnt         ;Draws the bar under Desk Access.
0582 D1A2              ;
0583 D1A2              ; Now print right and left borders of menu
0584 D1A2              ;
0585 D1A2 F4 14 00              pushword #$14                  ;$14 = 20 lines of bars in all
0586 D1A5 AD 72 1D              lda   |hpos
0587 D1A8 48                    pha                            ;save to use in following routine
0588 D1A9
0589 D1A9              loop      
0590 D1A9 A3 01                 lda   1,s
0591 D1AB 8D 72 1D              sta   |hpos
0592 D1AE EE 74 1D              inc   |vpos
0593 D1B1 68                    pla   
0594 D1B2 FA                    plx   
0595 D1B3 CA                    dex   
0596 D1B4 F0 19                 beq   cont                     ;Leave loop if borders are done
0597 D1B6 DA                    phx   
0598 D1B7 48                    pha   
0599 D1B8
0600 D1B8 A9 5A 00              lda   #$5A                     ;Left Border Bar Character
0601 D1BB 20 9F D6              jsr   MyCout
0602 D1BE
0603 D1BE A3 01                 lda   1,s                      ;replaces pla pha
0604 D1C0 18                    clc   
0605 D1C1 69 27 00              adc   #WindowWidth             ;Right Border = LeftBorder + Width
0606 D1C4 8D 72 1D              sta   |hpos
0607 D1C7
0608 D1C7 A9 5F 00              lda   #$5F                     ;Right Border Bar Char
0609 D1CA 20 9F D6              jsr   MyCout
0610 D1CD
0611 D1CD 80 DA                 bra   loop
0612 D1CF
0613 D1CF AD AC 1D     cont     lda   |dastrptr                ; mainstr for international
0614 D1D2 85 3C                 sta   temp1
0615 D1D4 AD AE 1D              lda   |dastrptr+2
0616 D1D7 85 3E                 sta   temp1+2
0617 D1D9 A0 0E 00              ldy   #$0E
0618 D1DC B7 3C                 lda   [temp1],y
0619 D1DE 85 42                 sta   temp2+2
0620 D1E0 88                    dey   
0621 D1E1 88                    dey   
0622 D1E2 B7 3C                 lda   [temp1],y
0623 D1E4 85 40                 sta   temp2
0624 D1E6 20 A5 D7              jsr   MyWriteCstringnt         ;draw bottom  "Select:....
0625 D1E9 EE 74 1D              inc   |vpos
0626 D1EC
0627 D1EC A9 D0 FE              lda   #>laststr
0628 D1EF 85 41                 sta   temp2+1
0629 D1F1 A9 45 D0              lda   #<laststr
0630 D1F4 85 40                 sta   temp2
0631 D1F6 20 A5 D7              jsr   MyWriteCStringnt         ;Draws the bar under Desk Access.
0632 D1F9
0633 D1F9              ;
0634 D1F9              ; if control panel active goto panelactive
0635 D1F9              ;
0636 D1F9 20 4E D6              jsr   panelactive
0637 D1FC AD 7C 1D              lda   |numdas                  ;calculate last vertical position which
0638 D1FF 90 01                 bcc   active
0639 D201 3A                    dec   a
0640 D202              active    
0641 D202
0642 D202 18                    clc                            ;contains text
0643 D203 69 05 00              adc   #$05                     ;This is used to know where quit will be
0644 D206 C9 11 00              cmp   #Top+NumLines-1          ;last line a DA can show on
0645 D209 90 03                 blt   ok
0646 D20B A9 11 00              lda   #Top+NumLines-1
0647 D20E 8D 70 1D     ok       sta   |bottomline              ;save last text position
0648 D211
0649 D211 20 E2 D4              jsr   UpdateCDAMenu            ;draw all available CDAs
0650 D214              ;
0651 D214              ; Calculate position to draw selected (inverted) item
0652 D214              ; Postion is top+(curcda-firstmenuitem)
0653 D214              ;
0654 D214
0655 D214 AD B0 1D              lda   |curcda
0656 D217 38                    sec   
0657 D218 ED 80 1D              sbc   |firstmenuitem
0658 D21B 18                    clc   
0659 D21C 69 04 00              adc   #top
0660 D21F 8D 74 1D              sta   |vpos                    ;invert string routine which inverts
0661 D222 AD 7E 1D              lda   |leftborder              ;the DA with some given number
0662 D225 8D 72 1D              sta   |hpos
0663 D228
0664 D228 A9 FF 00              lda   #$FF                     ; inverse
0665 D22B AC B0 1D              ldy   |curcda                  ;Item to highlight
0666 D22E 20 BE D7              jsr   writedaname              ;Always start by selecting first item
0667 D231
0668 D231
0669 D231 62 05 00     loop1    per   ret-1
0670 D234 AD 8A 1D              lda   |keyinput                ;simulate a jsr through |keyinput
0671 D237 3A                    dec   a                        ;(which isn't in the program bank!)
0672 D238 48                    pha   
0673 D239 60                    rts   
0674 D23A              ;
0675 D23A              ; Read keyboard and dispatch to appropriate routine
0676 D23A              ;
0677 D23A                       longa on
0678 D23A                       longi on
0679 D23A 29 7F 00     ret      and   #$7F
0680 D23D C9 0D 00              cmp   #$0D                     ;Open CDA?
0681 D240 D0 03                 bne   contt
0682 D242 4C 55 D4              jmp   gotreturn                ;Open it
0683 D245 C9 0B 00     contt    cmp   #$0B                     ;up arrow?
0684 D248 D0 03                 bne   contt1
0685 D24A 82 27 01              brl   upaline
0686 D24D              contt1    
0687 D24D C9 0A 00              cmp   #$0A                     ;down arrow?
0688 D250 F0 08                 beq   downaline
0689 D252 C9 1B 00              cmp   #$1B                     ;escape key
0690 D255 D0 DA                 bne   loop1
0691 D257 82 7A 01              brl   DoEscape
0692 D25A
0693 D25A              * Support routines for possible inputs follow
0694 D25A
0695 D25A C2 30        downaline longmx 
0696 D25C AC B0 1D              ldy   |curcda                  ; unhighlight current da
0697 D25F A9 00 00              lda   #$00
0698 D262 20 BE D7              jsr   writedaname
0699 D265 AD B0 1D              lda   |curcda                  ; if curcda = quit then do nothing
0700 D268 C9 FF 00              cmp   #$FF
0701 D26B D0 0B                 bne   cont1
0702 D26D              *If quit is selected, do nothing.
0703 D26D AD 7E 1D              lda   |leftborder
0704 D270 8D 72 1D              sta   |hpos
0705 D273 A9 FF 00              lda   #$FF
0706 D276 80 26                 bra   drawnam
0707 D278
0708 D278              cont1     
0709 D278              * first check to see if the apple key was also pressed.  If it was, we move by pages.
0710 D278 AD 25 C0              lda   |ModKeyReg               ;Modifier key register $c025
0711 D27B 29 80 00              and   #$0080                   ;apple key bit (page 124 harware ref)
0712 D27E D0 2B                 bne   DoPageDown
0713 D280              * here we move down 1 line
0714 D280              * first check if we need to scroll
0715 D280 AD 74 1D              lda   |vpos
0716 D283 C9 11 00              cmp   #Top+NumLines-1          ;are we at the bottom?
0717 D286 D0 03                 bne   contt2
0718 D288 82 C0 00              brl   scrollit
0719 D28B AD B0 1D     contt2   lda   |curcda
0720 D28E 1A                    inc   a                        ;bump to next cda
0721 D28F CD 7C 1D              cmp   |numdas                  ; if curcda > numdas ->
0722 D292 90 05                 bcc   nowrap1
0723 D294 F0 03                 beq   nowrap1
0724 D296
0725 D296 A9 FF 00              lda   #$FF                     ;set to quit
0726 D299
0727 D299 48           nowrap1  pha   
0728 D29A EE 74 1D              inc   |vpos
0729 D29D 68                    pla   
0730 D29E
0731 D29E 8D B0 1D     drawnam  sta   |curcda                  ; hilight curcda
0732 D2A1 A8                    tay   
0733 D2A2 A9 FF 00              lda   #$FF
0734 D2A5 20 BE D7              jsr   writedaname
0735 D2A8
0736 D2A8 82 86 FF              brl   loop1                    ; loop again
0737 D2AB
0738 D2AB              DoPageDown  
0739 D2AB              *Apple and the down arrow key were pressed
0740 D2AB AD 80 1D              lda   |firstmenuitem
0741 D2AE 18                    clc   
0742 D2AF 69 0D 00              adc   #numlines-1              ;this is the number of bottom menu item
0743 D2B2 CD B0 1D              cmp   |curcda                  ;is this the selected one?
0744 D2B5 F0 1A                 beq   DoPageDown1              ;branch if it is
0745 D2B7              *See if its over the end
0746 D2B7
0747 D2B7 CD 7C 1D              cmp   |numdas                  ;are we off the bottom of the menu?
0748 D2BA F0 05                 beq   DoPageDownOK             ;less than or = to #das
0749 D2BC 90 03                 bcc   DoPageDownOK             ;then we're not over the bottom
0750 D2BE
0751 D2BE A9 FF 00              lda   #$FF                     ;move to quit if off the end 
0752 D2C1 48           DoPageDownOK pha                        ;if it isn't, select and drawit
0753 D2C2 AD 70 1D              lda   |bottomline
0754 D2C5 8D 74 1D              sta   |vpos
0755 D2C8 AD 7E 1D              lda   |leftborder
0756 D2CB 8D 72 1D              sta   |hpos
0757 D2CE 68                    pla                            ;a has curcda
0758 D2CF 80 CD                 bra   drawnam
0759 D2D1              DoPageDown1  
0760 D2D1              *We want to page down
0761 D2D1 1A                    inc   a
0762 D2D2 8D 80 1D              sta   |firstmenuitem           ;page down by one
0763 D2D5 18                    clc   
0764 D2D6 69 0D 00              adc   #numlines-1              ;item on new screen bottom
0765 D2D9 CD 7C 1D              cmp   |numdas                  ;is it valid
0766 D2DC 90 27                 bcc   DoPageD2                 ;it's OK: scroll
0767 D2DE F0 25                 beq   DoPageD2                 ;it's Ok: scroll
0768 D2E0              *We went off the bottom.  Make quit the selected item.
0769 D2E0 AD 7C 1D              lda   |numdas
0770 D2E3 38                    sec   
0771 D2E4 E9 0C 00              sbc   #numlines-2              ;-2 to make room for quit
0772 D2E7 B0 03                 bcs   EndOfDown                ;were're ok: branch.  A has new start loc.
0773 D2E9
0774 D2E9 A9 00 00              lda   #0                       ;less menu items than lines.  Start @ top 
0775 D2EC 8D 80 1D     EndOfDown sta   |firstmenuitem
0776 D2EF 20 E2 D4              jsr   UpdateCDAMenu
0777 D2F2 A9 FF 00              lda   #$FF                     ;quit item
0778 D2F5 48                    pha   
0779 D2F6 AD 7E 1D     EndOfDown1 lda   |leftborder
0780 D2F9 8D 72 1D              sta   |hpos
0781 D2FC AD 70 1D              lda   |bottomline
0782 D2FF 8D 74 1D              sta   |vpos
0783 D302 68                    pla   
0784 D303 80 99                 bra   drawnam
0785 D305
0786 D305              DoPageD2  
0787 D305              *Here we just want to scroll down one page (numlines)
0788 D305 48                    pha   
0789 D306 20 E2 D4              jsr   UpdateCDAMenu
0790 D309 80 EB                 bra   EndOfDown1
0791 D30B
0792 D30B              DoPageUp  
0793 D30B              *Apple and the up arrow key were pressed
0794 D30B A9 04 00              lda   #top
0795 D30E 8D 74 1D              sta   |vpos
0796 D311 AD 7E 1D              lda   |leftborder
0797 D314 8D 72 1D              sta   |hpos
0798 D317 AD 80 1D              lda   |firstmenuitem
0799 D31A CD B0 1D              cmp   |curcda                  ;are we at the top?
0800 D31D F0 06                 beq   JumpUp                   ;branch if we are at top
0801 D31F 8D B0 1D              sta   |curcda                  ;set to top of screen
0802 D322 82 79 FF              brl   drawnam
0803 D325
0804 D325              JumpUp    
0805 D325              *Jump up one page (numlines)
0806 D325 38                    sec   
0807 D326 E9 0E 00              sbc   #NumLines                ;subtract from firstmenuitem
0808 D329 90 1B                 bcc   GoToTop                  ;branch if it puts us over the top
0809 D32B 8D 80 1D     JumpUp1  sta   |firstmenuitem           ;otherwise we move up by one page
0810 D32E 8D B0 1D              sta   |curcda
0811 D331 20 E2 D4              jsr   UpdateCDAMenu            ;scroll
0812 D334 A9 04 00              lda   #top                     ;we are at the top
0813 D337 8D 74 1D              sta   |vpos
0814 D33A AD 7E 1D              lda   |leftborder
0815 D33D 8D 72 1D              sta   |hpos
0816 D340 AD B0 1D              lda   |curcda
0817 D343 82 58 FF              brl   drawnam
0818 D346 A9 00 00     GoToTop  lda   #0
0819 D349 80 E0                 bra   JumpUp1
0820 D34B
0821 D34B              scrollit  
0822 D34B              *we are on last line.  Bump da pointer, scoll, then inverse video to select
0823 D34B AD B0 1D              lda   |curcda
0824 D34E 1A                    inc   a
0825 D34F CD 7C 1D              cmp   |numdas
0826 D352 90 05                 bcc   scrollit1                ;branch if not on last item
0827 D354 F0 03                 beq   scrollit1
0828 D356
0829 D356 A9 FF 00              lda   #$FF                     ;no more CDA's.  Quit is last item.
0830 D359 8D B0 1D     scrollit1 sta   |curcda                 ;we have the new DA number
0831 D35C EE 80 1D              inc   |firstmenuitem           ;start display one item later
0832 D35F 20 E2 D4              jsr   UpdateCDAMenu
0833 D362 A9 11 00              lda   #Top+Numlines-1
0834 D365 8D 74 1D              sta   |vpos
0835 D368 AD 7E 1D              lda   |leftborder
0836 D36B 8D 72 1D              sta   |hpos
0837 D36E AD B0 1D              lda   |curcda
0838 D371 82 2A FF              brl   drawnam
0839 D374
0840 D374 C2 30        upaline  longmx 
0841 D376
0842 D376 AC B0 1D              ldy   |curcda                  ; unhighlight current da
0843 D379 A9 00 00              lda   #$00
0844 D37C 20 BE D7              jsr   writedaname
0845 D37F              *move by pages?
0846 D37F AD 25 C0              lda   |ModKeyReg               ;Modifier key register $c025
0847 D382 29 80 00              and   #$0080                   ;apple key bit (page 124 harware ref)
0848 D385 F0 03                 beq   NoPageUp
0849 D387 82 81 FF              brl   DoPageUp                 ;jump by pages
0850 D38A
0851 D38A AD B0 1D     NoPageUp lda   |curcda                  ; if curcda = cntrl pan, wrap
0852 D38D D0 0C                 bne   cont2
0853 D38F
0854 D38F              *We're at the top (control panel)  Don't wrap.  Do nothing.
0855 D38F AD 7E 1D              lda   |leftborder
0856 D392 8D 72 1D              sta   |hpos
0857 D395 A9 00 00              lda   #0
0858 D398 82 03 FF              brl   drawnam
0859 D39B              *We're at the top (control panel)  
0860 D39B
0861 D39B              cont2     
0862 D39B              * not at control panel
0863 D39B              * check if we are at top
0864 D39B AD 74 1D              lda   |vpos
0865 D39E C9 04 00              cmp   #top
0866 D3A1 F0 12                 beq   scrollup                 ;if we're at the top we need to scroll up
0867 D3A3              ;
0868 D3A3              ;just move up a line; no scrolling necessary.  A contains vpos.
0869 D3A3              ;
0870 D3A3 3A                    dec   a
0871 D3A4 8D 74 1D              sta   |vpos
0872 D3A7 AD B0 1D              lda   |curcda
0873 D3AA C9 FF 00              cmp   #$FF
0874 D3AD D0 21                 bne   cont4
0875 D3AF AD 7C 1D              lda   |numdas
0876 D3B2 82 E9 FE              brl   drawnam
0877 D3B5
0878 D3B5              scrollup  
0879 D3B5              * Here we need to scroll up a line.  We know we're not @ the very top because
0880 D3B5              * we weren't @ the control panel
0881 D3B5              * We decrement firstmenuitem & redraw
0882 D3B5 CE 80 1D              dec   |firstmenuitem
0883 D3B8 CE B0 1D              dec   |curcda
0884 D3BB 20 E2 D4              jsr   UpdateCDAMenu
0885 D3BE A9 04 00              lda   #top
0886 D3C1 8D 74 1D              sta   |vpos
0887 D3C4 AD 7E 1D              lda   |leftborder
0888 D3C7 8D 72 1D              sta   |hpos
0889 D3CA AD B0 1D              lda   |curcda
0890 D3CD 82 CE FE              brl   drawnam
0891 D3D0
0892 D3D0 3A           cont4    dec   a
0893 D3D1 82 CA FE              brl   drawnam
0894 D3D4
0895 D3D4              DoEscape  
0896 D3D4              *here we select the quit item.
0897 D3D4
0898 D3D4 AC B0 1D              ldy   |curcda                  ; unhighlight current da
0899 D3D7 A9 00 00              lda   #$00
0900 D3DA 20 BE D7              jsr   writedaname
0901 D3DD              *Goto bottom
0902 D3DD              *First calculate new firstmenuitem = numdas-numlines
0903 D3DD
0904 D3DD              selectquititem  
0905 D3DD AD 7C 1D              lda   |numdas
0906 D3E0 38                    sec   
0907 D3E1 E9 0C 00              sbc   #numlines-2              ;-2 because 1 for quit and one because
0908 D3E4 B0 03                 bcs   selectok
0909 D3E6 A9 00 00              lda   #0
0910 D3E9 8D 80 1D     selectok sta   |firstmenuitem           ;we start with item 1 (ctrl. panel = 0)
0911 D3EC A9 FF 00              lda   #$FF
0912 D3EF 8D B0 1D              sta   |curcda
0913 D3F2 20 E2 D4              jsr   UpdateCDAMenu
0914 D3F5 AD 70 1D              lda   |bottomline
0915 D3F8 8D 74 1D              sta   |vpos
0916 D3FB A9 FF 00              lda   #$FF                     ;quit item
0917 D3FE 82 9D FE              brl   drawnam
0918 D401
0919 D401                       ENTRY DONE 
0920 D401              done                                    ;       
0921 D401 E2 30                 shortmx 
0922 D403 A9 FF                 lda   #$FF
0923 D405 85 32                 sta   $000032                  ; inverse flag
0924 D407 C2 30                 longmx 
0925 D409
0926 D409 FA                    plx                            ;get bit encoded slot configuation
0927 D40A A9 00 03              lda   #$0300
0928 D40D 22 08 02 E1           jsl   Slot_Arbiter             ;restore original configuration
0929 D411
0930 D411              ;
0931 D411              ; Need to unlock table of CDA's (|CDATabHndl) when exiting.  setuptab (called by
0932 D411              ; initstuff (below) locked the table.
0933 D411              ;
0934 D411 AD 86 1D              lda   |CDATabHndl+2
0935 D414 48                    pha   
0936 D415 AD 84 1D              lda   |CDATabHndl
0937 D418 48                    pha   
0938 D419 A2 02 22 22           _HUnlock 
0939 D420
0940 D420 AB                    plb   
0941 D421 5C DF FB FE           jml   oendcall0
0942 D425                       ENDP 
0943 D425
0944 D425                       EXPORT initstuff
0945 D425              initstuff PROC 
0946 D425 A9 17 00              lda   #LeftBorder80            ;default init assumes 80 column screen
0947 D428 8D 7E 1D              sta   |leftborder
0948 D42B A9 14 00              lda   #LeftBorder80-3          ;start position for border of menu
0949 D42E 8D 72 1D              sta   |hpos
0950 D431 A9 00 00              lda   #0
0951 D434 8D 74 1D              sta   |vpos
0952 D437 20 34 D8              jsr   setuptab                 ;sets up table of CDA strings
0953 D43A E2 20                 sep   #$20
0954 D43C                       longa off
0955 D43C 8F 0D C0 00           sta   >$00C00d
0956 D440 8F 01 C0 00           sta   >$00C001
0957 D444
0958 D444 AF 2D C0 00           lda   >$00C02d
0959 D448 29 08                 and   #$08
0960 D44A D0 06                 bne   NotInternalSlot3
0961 D44C A9 00                 lda   #0
0962 D44E 8F FB 07 00           sta   >$0007FB
0963 D452              NotInternalSlot3  
0964 D452 C2 20                 rep   #$20
0965 D454                       longa on
0966 D454              ;
0967 D454              ; Set up screen holes to the values CDA expect
0968 D454              ;
0969 D454
0970 D454 60                    rts   
0971 D455                       ENDP 
0972 D455
0973 D455              gotreturn PROC EXPORT 
0974 D455
0975 D455 C2 30                 longmx 
0976 D457 AD B0 1D              lda   |curcda
0977 D45A F0 0B                 beq   conpan
0978 D45C C9 FF 00              cmp   #$FF
0979 D45F F0 15                 beq   quitcode
0980 D461
0981 D461 20 55 D8              jsr   openda
0982 D464 4C E3 D0              jmp   choosecdaWarm
0983 D467
0984 D467 E2 30        conpan   shortmx 
0985 D469 A9 00                 lda   #$00                     ; set b to bank zero
0986 D46B 48                    pha   
0987 D46C AB                    plb   
0988 D46D 22 90 00 E1           jsl   toctrl_panel
0989 D471 C2 30                 longmx 
0990 D473 4C E3 D0              jmp   choosecdaWarm
0991 D476
0992 D476 4C 01 D4     quitcode jmp   done
0993 D479
0994 D479                       ENDP 
0995 D479
0996 D479              monkeyin PROC EXPORT 
0997 D479 E2 30                 shortmx 
0998 D47B
0999 D47B AD 00 C0              lda   $C000                    ;read keyboard
1000 D47E 10 F9                 bpl   monkeyin                 ;wait for keypress
1001 D480 8D 10 C0              sta   $C010                    ;acknowledge keypress: clear keyboard
1002 D483 C2 30                 longmx 
1003 D485 60                    rts   
1004 D486
1005 D486                       ENDP 
1006 D486
1007 D486                       EXPORT evntkeyin
1008 D486              evntkeyin PROC 
1009 D486
1010 D486 F4 00 00              pushword #$00                  ; result
1011 D489 F4 FF FF              pushword #$FFFF                ;event mask -- keyboard only
1012 D48C F4 E0 00              pea   evntrec>>16
1013 D48F F4 8C 1D              pea   evntrec**$FFFF
1014 D492 A2 06 0A 22           _GetNextEvent 
1015 D499 68                    pla   
1016 D49A F0 EA                 beq   evntkeyin                ; if 0 we don't handle
1017 D49C AD 8C 1D              lda   |evntrec
1018 D49F C9 03 00              cmp   #$03
1019 D4A2 F0 05                 beq    @1                      ; if keydown then exit
1020 D4A4 C9 05 00              cmp   #$05
1021 D4A7 D0 DD                 bne   evntkeyin                ; if not autokey then skip
1022 D4A9 AD 8E 1D     @1       lda   |message
1023 D4AC 29 FF 00              and   #$00FF                   ; make sure we only have bottom byte
1024 D4AF 60                    rts   
1025 D4B0
1026 D4B0                       ENDP 
1027 D4B0
1028 D4B0                       EXPORT pg2kludge
1029 D4B0              pg2kludge PROC 
1030 D4B0 B4 D4 FE 00           DC L:foo
1031 D4B4
1032 D4B4 16           foo      DC B:$16
1033 D4B5 C1 EC F4 E5           DC B:'Alternate Display Mode'
1034 D4CB D3 D4 FE 00           DC L:open
1035 D4CF E1 D4 FE 00           DC L:AnRTL
1036 D4D3
1037 D4D3 E2 30        open     shortmx 
1038 D4D5 8B                    phb   
1039 D4D6 A9 00                 lda   #$00
1040 D4D8 48                    pha   
1041 D4D9 AB                    plb   
1042 D4DA 22 A4 00 E1           jsl   topg2kludge
1043 D4DE AB                    plb   
1044 D4DF C2 30                 longmx 
1045 D4E1 6B           AnRTL    rtl   
1046 D4E2
1047 D4E2                       ENDP 
1048 D4E2
1049 D4E2              **********************************************************************
1050 D4E2              *
1051 D4E2              * This routine displays the CDAs
1052 D4E2              *
1053 D4E2              * The Pascal string list of CDA names is assumed to be setup already
1054 D4E2              *
1055 D4E2              * The first DA shown is in |firstmenuitem (0 = first one = Control Panel)
1056 D4E2              *
1057 D4E2              * |numdas contains the number of CDAs in the list
1058 D4E2              *
1059 D4E2              * This routine is called at the beginning and everytime the display 
1060 D4E2              * scrolls.
1061 D4E2              *
1062 D4E2              * Added by Konstantin Othmer Sept 21, 1988
1063 D4E2              *
1064 D4E2              ****************************************************************
1065 D4E2                       EXPORT UpdateCDAMenu
1066 D4E2              UpdateCDAMenu PROC 
1067 D4E2              * Set cursor to first location.
1068 D4E2 AD 7E 1D              lda   |leftborder
1069 D4E5 8D 72 1D              sta   |hpos
1070 D4E8 A9 03 00              lda   #Top-1                   ;vertical text start position  
1071 D4EB 8D 74 1D              sta   |vpos
1072 D4EE
1073 D4EE              ;
1074 D4EE              ; check if jumper is in
1075 D4EE              ; force it in for testing purposes
1076 D4EE              ;
1077 D4EE 20 4E D6              jsr   panelactive
1078 D4F1 90 15                 bcc   test2                    ;panel active => goto test2
1079 D4F3              ;
1080 D4F3              ;control panel not active - force firstmenuitem to 1 if it is 0 and same with curcda
1081 D4F3              ;
1082 D4F3 AD B0 1D              lda   |curcda
1083 D4F6 D0 07                 bne   test1
1084 D4F8 1A                    inc   a
1085 D4F9 8D B0 1D              sta   |curcda
1086 D4FC 8D 80 1D              sta   |firstmenuitem
1087 D4FF AD 80 1D     test1    lda   |firstmenuitem
1088 D502 D0 04                 bne   test2
1089 D504 1A                    inc   a
1090 D505 8D 80 1D              sta   |firstmenuitem
1091 D508              test2     
1092 D508
1093 D508              * If we are at item 0, print a blank line and 'control panel'
1094 D508
1095 D508 AD 80 1D              lda   |firstmenuitem
1096 D50B D0 3A                 bne   Update0
1097 D50D
1098 D50D              *We're @ top.  Blank uparrows if they are there by drawing blank line
1099 D50D
1100 D50D A9 D0 FE              lda   #>blankline
1101 D510 85 41                 sta   temp2+1
1102 D512 A9 87 D0              lda   #<blankline
1103 D515 85 40                 sta   temp2
1104 D517 20 6F D7              jsr   MyWriteCString
1105 D51A
1106 D51A AD 7E 1D              lda   |leftborder
1107 D51D 8D 72 1D              sta   |hpos
1108 D520 EE 74 1D              inc   |vpos
1109 D523
1110 D523 A9 D0 FE              lda   #>blankline              ;blank control panel line to the end
1111 D526 85 41                 sta   temp2+1
1112 D528 A9 87 D0              lda   #<blankline
1113 D52B 85 40                 sta   temp2
1114 D52D 20 6F D7              jsr   MyWriteCString
1115 D530
1116 D530 AD 7E 1D              lda   |leftborder
1117 D533 8D 72 1D              sta   |hpos
1118 D536 A9 00 00              lda   #0                       ;normal text
1119 D539 A0 00 00              ldy   #0                       ;control panel
1120 D53C 20 BE D7              jsr   writedaname              ;print control panel: item 0
1121 D53F EE 74 1D              inc   |vpos
1122 D542 A0 01 00              ldy   #1                       ;y-reg contains number of 1st item to do
1123 D545 80 35                 bra   Update1
1124 D547              Update0   
1125 D547              ;not at top.  print up arrows @ top-1
1126 D547              ;
1127 D547              ; If control panel enabled => goto test3
1128 D547              ;
1129 D547 20 4E D6              jsr   panelactive
1130 D54A 90 17                 bcc   test3
1131 D54C              ;
1132 D54C              ; control panel not enabled: skip arrows when 1,1
1133 D54C              ;
1134 D54C AD 80 1D              lda   |firstmenuitem
1135 D54F C9 01 00              cmp   #1
1136 D552 D0 0F                 bne   test3
1137 D554              ;
1138 D554              ; Blank uparrows line
1139 D554              ;
1140 D554 A9 D0 FE              lda   #>blankline
1141 D557 85 41                 sta   temp2+1
1142 D559 A9 87 D0              lda   #<blankline
1143 D55C 85 40                 sta   temp2
1144 D55E 20 6F D7              jsr   MyWriteCString
1145 D561 80 0D                 bra   test4
1146 D563
1147 D563              test3     
1148 D563 A9 D0 FE              lda   #>uparrows
1149 D566 85 41                 sta   temp2+1
1150 D568 A9 6D D0              lda   #<uparrows
1151 D56B 85 40                 sta   temp2
1152 D56D 20 A5 D7              jsr   MyWriteCStringnt
1153 D570              test4     
1154 D570 AD 7E 1D              lda   |leftborder
1155 D573 8D 72 1D              sta   |hpos
1156 D576 EE 74 1D              inc   |vpos
1157 D579 AC 80 1D              ldy   |firstmenuitem
1158 D57C              Update1   
1159 D57C A9 00 00              lda   #0
1160 D57F 48                    pha                            ;set up flag for quit item
1161 D580 AD 7C 1D              lda   |numdas                  ;calculate number of items to print
1162 D583
1163 D583              *number of items to print is numdas - firstmenuitem +1
1164 D583
1165 D583 38                    sec                            ;x-reg will contain number of items to do
1166 D584 ED 80 1D              sbc   |firstmenuitem
1167 D587 AA                    tax   
1168 D588 AD 80 1D              lda   |firstmenuitem           ;Did we do control panel (above)?
1169 D58B D0 11                 bne   Update2                  ;If we didn't, branch.
1170 D58D
1171 D58D              *This section assumes control panel done.
1172 D58D
1173 D58D
1174 D58D E0 0C 00              cpx   #NumLines-2              ;Control panel and quit each take up one line
1175 D590 90 1A                 bcc   Update4                  ;If 13 or less, there is quit item: branch
1176 D592 F0 18                 beq   Update4
1177 D594 A2 0D 00              ldx   #NumLines-1              ;print maximum w/ control panel & no quit
1178 D597 A9 FF FF              lda   #$ffff                   ;signal no quit item
1179 D59A 83 01                 sta   1,s
1180 D59C 80 0E                 bra   Update4
1181 D59E              Update2   
1182 D59E              * No Control Panel
1183 D59E E8                    inx   
1184 D59F E0 0E 00              cpx   #NumLines                ;Total length of display
1185 D5A2 90 08                 bcc   Update4                  ;branch on 14 or less
1186 D5A4 A2 0E 00              ldx   #NumLines                ;print maximum w/o control panel & no quit
1187 D5A7 A9 FF FF              lda   #$ffff                   ;signal no quit item
1188 D5AA 83 01                 sta   1,s
1189 D5AC
1190 D5AC              Update4   
1191 D5AC 20 13 D6              jsr   PrintDAList              ;Print list of DAs
1192 D5AF              * Handle Quit Item
1193 D5AF AD 7E 1D              lda   |leftborder
1194 D5B2 8D 72 1D              sta   |hpos
1195 D5B5 68                    pla                            ;$ff signals no quit item, 0 signals quit
1196 D5B6 D0 3A                 bne   DoDownArrows
1197 D5B8
1198 D5B8 AD 70 1D              lda   |bottomline
1199 D5BB 8D 74 1D              sta   |vpos
1200 D5BE AD 7E 1D              lda   |leftborder
1201 D5C1 8D 72 1D              sta   |hpos
1202 D5C4
1203 D5C4 A9 D0 FE              lda   #>blankline
1204 D5C7 85 41                 sta   temp2+1
1205 D5C9 A9 87 D0              lda   #<blankline
1206 D5CC 85 40                 sta   temp2
1207 D5CE 20 6F D7              jsr   MyWriteCString
1208 D5D1
1209 D5D1 AD 7E 1D              lda   |leftborder
1210 D5D4 8D 72 1D              sta   |hpos
1211 D5D7 A9 00 00              lda   #0                       ; normal
1212 D5DA A0 FF 00              ldy   #$FF                     ;quit item identification
1213 D5DD 20 BE D7              jsr   writedaname
1214 D5E0
1215 D5E0              * Here we erase bottom row.  It may contain down arrows which we don't want.
1216 D5E0 EE 74 1D              inc   |vpos
1217 D5E3
1218 D5E3 A9 D0 FE              lda   #>blankline
1219 D5E6 85 41                 sta   temp2+1
1220 D5E8 A9 87 D0              lda   #<blankline
1221 D5EB 85 40                 sta   temp2
1222 D5ED 20 6F D7              jsr   MyWriteCString
1223 D5F0
1224 D5F0 80 20                 bra   UpdateDone
1225 D5F2              DoDownArrows  
1226 D5F2              ;
1227 D5F2              ; There is no quit item, so there must be more.  A "*** more ***" message shows this.
1228 D5F2              ;
1229 D5F2 A9 D0 FE              lda   #>blankline
1230 D5F5 85 41                 sta   temp2+1
1231 D5F7 A9 87 D0              lda   #<blankline
1232 D5FA 85 40                 sta   temp2
1233 D5FC 20 6F D7              jsr   MyWriteCString
1234 D5FF
1235 D5FF AD 7E 1D              lda   |leftborder
1236 D602 8D 72 1D              sta   |hpos
1237 D605
1238 D605 A9 D0 FE              lda   #>downarrows
1239 D608 85 41                 sta   temp2+1
1240 D60A A9 7A D0              lda   #<downarrows
1241 D60D 85 40                 sta   temp2
1242 D60F 20 A5 D7              jsr   MyWriteCStringnt
1243 D612
1244 D612
1245 D612              UpdateDone  
1246 D612 60                    rts   
1247 D613                       ENDP 
1248 D613
1249 D613
1250 D613              **********************************************************************
1251 D613              *
1252 D613              * PrintDAList
1253 D613              *
1254 D613              *  Prints an excerpt from a list of C-strings
1255 D613              *
1256 D613              * y-reg has # of 1st item to print (list starts at 1)
1257 D613              * x-reg has # of items to print
1258 D613              *
1259 D613              * Routine assumes initial print location is set up 
1260 D613              *
1261 D613              * Everything printed in normal (not inverse) type
1262 D613              *
1263 D613              * Added by Konstantin Othmer Sept 21, 1988
1264 D613              *
1265 D613              **********************************************************************
1266 D613                       EXPORT PrintDAList
1267 D613              PrintDAList PROC 
1268 D613 E8                    inx   
1269 D614 CA           PrintC1  dex                            ;Number items left zero?
1270 D615 F0 36                 beq   PrintCDone
1271 D617 DA                    phx   
1272 D618 5A                    phy   
1273 D619
1274 D619 AD 7E 1D              lda   |leftborder
1275 D61C 8D 72 1D              sta   |hpos
1276 D61F 7A                    ply   
1277 D620 5A                    phy   
1278 D621 A9 00 00              lda   #0                       ;normal
1279 D624 20 BE D7              jsr   writedaname              ;does not change |hpos
1280 D627 18                    clc                            ;a-reg contains length of da string
1281 D628 6D 72 1D              adc   |hpos
1282 D62B 8D 72 1D              sta   |hpos
1283 D62E
1284 D62E              PrintLoop  
1285 D62E AD 7E 1D              lda   |leftborder
1286 D631 18                    clc   
1287 D632 69 24 00              adc   #36                      ;screen width
1288 D635 CD 72 1D              cmp   |hpos                    ;have we filled to the right border yet?
1289 D638 F0 0B                 beq   LoopDone
1290 D63A A9 A0 00              lda   #' '
1291 D63D 20 9F D6              jsr   Mycout                   ;blank char
1292 D640 EE 72 1D              inc   |hpos
1293 D643 80 E9                 bra   PrintLoop
1294 D645
1295 D645              LoopDone  
1296 D645 EE 74 1D              inc   |vpos                    ;advance vertical position
1297 D648 7A                    ply   
1298 D649 FA                    plx   
1299 D64A C8                    iny   
1300 D64B 80 C7                 bra   PrintC1
1301 D64D 60           PrintCDone rts   
1302 D64E                       ENDP 
1303 D64E
1304 D64E              **********************************************************************
1305 D64E              *
1306 D64E              * PanelActive
1307 D64E              *
1308 D64E              *  Checks whether or not to display the control panel.  This is set
1309 D64E              * via a jumper on the board.  The jumper controls bit 7 of $00C046.  If
1310 D64E              * bit 7 of $00C046 = 0 then we show the control panel and return with the 
1311 D64E              * carry clear.  Otherwise the carry is set.
1312 D64E              * 
1313 D64E              *
1314 D64E              PanelActive PROC EXPORT 
1315 D64E 48                    pha   
1316 D64F DA                    phx   
1317 D650 5A                    phy   
1318 D651
1319 D651 F4 E1 00 F4           pushlong #IsPanelActive 
1320 D657 F4 FE 00 F4           pushlong #ReadLocation 
1321 D65D F4 09 00              pea   $0009                    ;read location and store result at IsPanelActive
1322 D660 A2 09 0B 22           _ReadKeyMicroMemory 
1323 D667
1324 D667 AF A5 01 E1           lda   >IsPanelActive
1325 D66B 29 40 00              and   #$0040                   ;save bit 6
1326 D66E F0 03                 beq   PanelShow
1327 D670 38                    sec                            ;don't show control panel
1328 D671 80 01                 bra   PanelDone
1329 D673
1330 D673 18           PanelShow clc                           ;show control panel
1331 D674              PanelDone  
1332 D674 7A                    ply   
1333 D675 FA                    plx   
1334 D676 68                    pla   
1335 D677 60                    rts   
1336 D678
1337 D678 E8 00 00 00  ReadLocation DC L:$00E8                 ;key micro $E8 bit 6 has control panel jumper
1338 D67C
1339 D67C                       ENDP 
1340 D67C
1341 D67C
1342 D67C              **********************************************************************
1343 D67C              *
1344 D67C              * SetPanelActive
1345 D67C              *
1346 D67C              *  Checks whether or not to display the control panel.  This is set
1347 D67C              * via a jumper on the board.  The jumper controls bit 7 of $00C046.  If
1348 D67C              * bit 7 of $00C046 = 0 then we show the control panel and return with the 
1349 D67C              * carry clear.  Otherwise the carry is set.
1350 D67C              *
1351 D67C              ****************************************************************
1352 D67C              SetPanelActive PROC EXPORT 
1353 D67C              ;	pha
1354 D67C              ;	sep	#$20	;8 bit m
1355 D67C              ;	longa	off
1356 D67C              ;	lda	>$00C060
1357 D67C              ;	rep	#$20
1358 D67C              ;	longa	on
1359 D67C              ;	and	#$0080
1360 D67C              ;	eor	#$0080	;change sense of bit
1361 D67C              ;	sta	>IsPanelActive
1362 D67C              ;	pla
1363 D67C 60                    rts   
1364 D67D                       ENDP 
1365 D67D
1366 D67D              **********************************************************************
1367 D67D              *
1368 D67D              * Sends character in a to $FDED
1369 D67D              *
1370 D67D              ****************************************************************
1371 D67D                       EXPORT cout
1372 D67D              cout     PROC 
1373 D67D
1374 D67D
1375 D67D F4 00 00              pea   00                       ; space for result
1376 D680 F4 00 00              pea   00                       ; space for result
1377 D683 F4 00 00              pea   00                       ; space for result
1378 D686 F4 00 00              pea   00                       ; space for result
1379 D689 48                    pha                            ; acc at entry
1380 D68A F4 00 00              pea   00                       ; xreg at entry
1381 D68D F4 00 00              pea   00                       ; yreg at entry
1382 D690 F4 ED FD              pea   $FDED
1383 D693 A2 03 24 22           _FWEntry 
1384 D69A 68                    pla   
1385 D69B 68                    pla   
1386 D69C 68                    pla   
1387 D69D 68                    pla   
1388 D69E
1389 D69E 60                    rts   
1390 D69F                       ENDP 
1391 D69F
1392 D69F              **********************************************************************
1393 D69F              *
1394 D69F              * Screen driver:  A-reg contains character to print
1395 D69F              *
1396 D69F              **********************************************************************
1397 D69F                       EXPORT MyCout
1398 D69F              MyCout   PROC 
1399 D69F 29 FF 00              and   #$00FF
1400 D6A2 48                    pha                            ;save character to print
1401 D6A3 20 D1 D6              jsr   SetScreenLoc
1402 D6A6 AE 76 1D              ldx   |CurScreenLoc
1403 D6A9 E0 00 04              cpx   #$400
1404 D6AC B0 0F                 bcs   DoBank1
1405 D6AE BF 00 04 00           lda   >$400,x                  ;screen
1406 D6B2 29 00 FF              and   #$FF00
1407 D6B5 03 01                 ora   1,s
1408 D6B7 9F 00 04 00           sta   >$400,x
1409 D6BB 80 12                 bra   Bank0Done
1410 D6BD              DoBank1   
1411 D6BD 8A                    txa   
1412 D6BE 29 FF 03              and   #$03FF
1413 D6C1 AA                    tax   
1414 D6C2 BF 00 04 01           lda   >$010400,x               ;screen
1415 D6C6 29 00 FF              and   #$FF00
1416 D6C9 03 01                 ora   1,s
1417 D6CB 9F 00 04 01           sta   >$010400,x
1418 D6CF              Bank0Done  
1419 D6CF 68                    pla   
1420 D6D0 60                    rts   
1421 D6D1
1422 D6D1                       ENDP 
1423 D6D1
1424 D6D1              **********************************************************************
1425 D6D1              *
1426 D6D1              * Sets SetScreenLoc to position specified in Hpos and Vpos.  Uses MyCout.
1427 D6D1              *
1428 D6D1              ****************************************************************
1429 D6D1                       EXPORT SetScreenLoc
1430 D6D1              SetScreenLoc PROC 
1431 D6D1              ;
1432 D6D1              ;Calculate starting position.  Lookup ypos start and then add xpos
1433 D6D1              ;
1434 D6D1 AD 74 1D              lda   |Vpos
1435 D6D4 0A                    asl   a
1436 D6D5 AA                    tax   
1437 D6D6 BF 0B D7 FE           lda   >ScreenTab,x             ;get starting screen location
1438 D6DA
1439 D6DA 8D 76 1D              sta   |CurScreenLoc
1440 D6DD AD 7E 1D              lda   |Leftborder
1441 D6E0 C9 04 00              cmp   #4                       ;if less than 4, then 40 column mode
1442 D6E3 90 1B                 bcc   FortyColumn
1443 D6E5              ;
1444 D6E5              ; Do 80 column stuff.
1445 D6E5              ;
1446 D6E5
1447 D6E5 AD 72 1D              lda   |Hpos
1448 D6E8 48                    pha   
1449 D6E9 4A                    lsr   a
1450 D6EA 18                    clc   
1451 D6EB 6D 76 1D              adc   |CurScreenLoc
1452 D6EE 8D 76 1D              sta   |CurScreenLoc
1453 D6F1 68                    pla   
1454 D6F2 4A                    lsr   a                        ;odd or even position?
1455 D6F3 B0 09                 bcs   OnBank0
1456 D6F5 AD 76 1D              lda   |CurScreenLoc
1457 D6F8 09 00 04              ora   #$400
1458 D6FB 8D 76 1D              sta   |CurScreenLoc
1459 D6FE              OnBank0   
1460 D6FE 80 0A                 bra   AllDone
1461 D700 AD 72 1D     FortyColumn lda   |Hpos
1462 D703 18                    clc   
1463 D704 6D 76 1D              adc   |CurScreenLoc
1464 D707 8D 76 1D              sta   |CurScreenLoc
1465 D70A 60           AllDone  rts   
1466 D70B
1467 D70B 00 00 80 00  ScreenTab DC W:$000,$080,$100,$180,$200,$280,$300,$380
1468 D71B 28 00 A8 00           DC W:$028,$0A8,$128,$1A8,$228,$2A8,$328,$3A8
1469 D72B 50 00 D0 00           DC W:$050,$0D0,$150,$1D0,$250,$2D0,$350,$3D0
1470 D73B                       ENDP 
1471 D73B
1472 D73B
1473 D73B              **********************************************************************
1474 D73B              *
1475 D73B              * Faster writeline routine.  Uses MyCout.
1476 D73B              *
1477 D73B              *  Assumes pointer to p-string is in temp2
1478 D73B              *
1479 D73B              **********************************************************************
1480 D73B                       EXPORT MyWriteLine
1481 D73B              MyWriteLine PROC 
1482 D73B
1483 D73B A7 40                 lda   [temp2]
1484 D73D 29 3F 00              and   #$3f                     ;get string length
1485 D740 1A                    inc   a                        ;offset because compare is done before print
1486 D741 48                    pha   
1487 D742 A0 01 00              ldy   #1
1488 D745 B7 40        PrintLoop lda   [temp2],y
1489 D747 24 31                 bit   $000031                  ;bit 7 of inverse flag
1490 D749 30 11                 bmi   NormalVideo
1491 D74B
1492 D74B 29 7F 00              and   #$7F
1493 D74E 48                    pha   
1494 D74F              ;
1495 D74F              ;check for upper case inverse text
1496 D74F              ;
1497 D74F 29 20 00              and   #$20
1498 D752 D0 05                 bne   ItsLowerCase
1499 D754 68                    pla   
1500 D755 29 BF 00              and   #$BF                     ;reset bit 6
1501 D758 48                    pha   
1502 D759
1503 D759              ItsLowerCase  
1504 D759 68                    pla   
1505 D75A 80 03                 bra   DoVideo
1506 D75C              NormalVideo  
1507 D75C 09 80 00              ora   #$80
1508 D75F              DoVideo   
1509 D75F 5A                    phy   
1510 D760 20 9F D6              jsr   Mycout
1511 D763 EE 72 1D              inc   |hpos
1512 D766 7A                    ply   
1513 D767 C8           Did1Character iny   
1514 D768 98                    tya   
1515 D769 C3 01                 cmp   1,s
1516 D76B D0 D8                 bne   PrintLoop
1517 D76D 68                    pla                            ;clear stack
1518 D76E 60                    rts   
1519 D76F                       ENDP 
1520 D76F
1521 D76F              **********************************************************************
1522 D76F              *
1523 D76F              * Faster writeCString routine.  Uses MyCout.
1524 D76F              *
1525 D76F              *  Assumes pointer to p-string is in temp2
1526 D76F              *
1527 D76F              ****************************************************************
1528 D76F                       EXPORT MyWriteCString
1529 D76F              MyWriteCString PROC 
1530 D76F
1531 D76F AE 72 1D              ldx   |hpos
1532 D772 DA                    phx   
1533 D773
1534 D773              Translate  
1535 D773 A0 00 00              ldy   #0
1536 D776              PrintLoop  
1537 D776 B7 40                 lda   [temp2],y
1538 D778 29 FF 00              and   #$FF
1539 D77B F0 23                 beq   Done
1540 D77D 24 31                 bit   $000031                  ;bit 7 of inverse flag
1541 D77F 30 11                 bmi   NormalVideo
1542 D781
1543 D781 29 7F 00              and   #$7F
1544 D784 48                    pha   
1545 D785              ;
1546 D785              ;check for upper case inverse text
1547 D785              ;
1548 D785 29 20 00              and   #$20
1549 D788 D0 05                 bne   ItsLowerCase
1550 D78A 68                    pla   
1551 D78B 29 BF 00              and   #$BF                     ;reset bit 6
1552 D78E 48                    pha   
1553 D78F
1554 D78F              ItsLowerCase  
1555 D78F 68                    pla   
1556 D790 80 03                 bra   DoVideo
1557 D792              NormalVideo  
1558 D792 09 80 00              ora   #$80
1559 D795              DoVideo   
1560 D795 5A                    phy   
1561 D796 20 9F D6              jsr   Mycout
1562 D799 EE 72 1D              inc   |hpos
1563 D79C 7A                    ply   
1564 D79D C8                    iny   
1565 D79E 80 D6                 bra   PrintLoop
1566 D7A0
1567 D7A0 FA           Done     plx   
1568 D7A1 8E 72 1D              stx   |hpos
1569 D7A4 60                    rts   
1570 D7A5              ;
1571 D7A5              ; don't translate characters
1572 D7A5              ;
1573 D7A5                       EXPORT MyWriteCStringnt
1574 D7A5              MyWriteCStringnt  
1575 D7A5 AE 72 1D              ldx   |hpos
1576 D7A8 DA                    phx   
1577 D7A9 A0 00 00              ldy   #0
1578 D7AC              NoTLoop   
1579 D7AC B7 40                 lda   [temp2],y
1580 D7AE 29 FF 00              and   #$FF
1581 D7B1 F0 ED                 beq   Done
1582 D7B3 5A                    phy   
1583 D7B4 20 9F D6              jsr   Mycout
1584 D7B7 EE 72 1D              inc   |hpos
1585 D7BA 7A                    ply   
1586 D7BB C8                    iny   
1587 D7BC 80 EE                 bra   NoTLoop
1588 D7BE
1589 D7BE                       ENDP 
1590 D7BE
1591 D7BE              ;-----------------------------------------------------------
1592 D7BE              ; Write the name of the da corresponding to the number in the y
1593 D7BE              ; register at the current cursor position. If the accumulator is zero
1594 D7BE              ; then the item is drawn in 'normal' mode. If non-zero, the name is
1595 D7BE              ; displayed in inverse mode. Note that the routine assumes that
1596 D7BE              ; cdatabptr is valid and cdatab is locked.
1597 D7BE
1598 D7BE                       EXPORT writedaname
1599 D7BE              writedaname PROC 
1600 D7BE
1601 D7BE C9 00 00              cmp   #$00
1602 D7C1 D0 0A                 bne   inverse
1603 D7C3
1604 D7C3 E2 30                 shortmx 
1605 D7C5 A9 FF                 lda   #$FF
1606 D7C7 85 32                 sta   $000032                  ; clear the inverse flag
1607 D7C9 C2 30                 longmx 
1608 D7CB 80 08                 bra   cont
1609 D7CD
1610 D7CD E2 30        inverse  shortmx 
1611 D7CF A9 7F                 lda   #$7F
1612 D7D1 85 32        cont     sta   $000032                  ; set the inverse flag
1613 D7D3 C2 30                 longmx 
1614 D7D5
1615 D7D5              cont      
1616 D7D5 C0 00 00              cpy   #$00
1617 D7D8 D0 07                 bne   cont1
1618 D7DA
1619 D7DA A0 06 00              ldy   #$06                     ; offset to control panel string
1620 D7DD 20 1A D8              jsr   drbltin                  ; write the string
1621 D7E0 60                    rts   
1622 D7E1
1623 D7E1 C0 FF 00     cont1    cpy   #$FF
1624 D7E4 D0 07                 bne   cont2
1625 D7E6
1626 D7E6 A0 0A 00              ldy   #$0A                     ; offset to quit string
1627 D7E9 20 1A D8              jsr   drbltin
1628 D7EC 60                    rts   
1629 D7ED
1630 D7ED AD A8 1D     cont2    lda   |cdatabptr               ; copy the table pointer into
1631 D7F0 85 40                 sta   temp2                    ; the direct page
1632 D7F2 AD AA 1D              lda   |cdatabptr+2
1633 D7F5 85 42                 sta   temp2+2
1634 D7F7 98                    tya   
1635 D7F8 3A                    dec   a
1636 D7F9 0A                    asl   a                        ; adjust y
1637 D7FA 0A                    asl   a
1638 D7FB A8                    tay   
1639 D7FC B7 40                 lda   [temp2],y                ; get a handle to the da
1640 D7FE 85 3C                 sta   temp1
1641 D800 C8                    iny   
1642 D801 C8                    iny   
1643 D802 B7 40                 lda   [temp2],y
1644 D804 85 3E                 sta   temp1+2
1645 D806 20 97 D8              jsr   deref                    ; deref the handle
1646 D809
1647 D809 AD 72 1D              lda   |hpos
1648 D80C 48                    pha   
1649 D80D 20 3B D7              jsr   MyWriteline
1650 D810 68                    pla   
1651 D811 8D 72 1D              sta   |hpos
1652 D814 A7 40                 lda   [temp2]                  ;length of string
1653 D816 29 3F 00              and   #$3f                     ;only byte long
1654 D819 60                    rts   
1655 D81A
1656 D81A 5A           drbltin  phy   
1657 D81B AD AC 1D              lda   |dastrptr                ; high part
1658 D81E 85 3C                 sta   temp1
1659 D820 AD AE 1D              lda   |dastrptr+2              ; lo part
1660 D823 85 3E                 sta   temp1+2
1661 D825 7A                    ply   
1662 D826 B7 3C                 lda   [temp1],y
1663 D828 85 42                 sta   temp2+2
1664 D82A 88                    dey   
1665 D82B 88                    dey   
1666 D82C B7 3C                 lda   [temp1],y
1667 D82E 85 40                 sta   temp2
1668 D830 20 6F D7              jsr   MyWriteCString
1669 D833 60                    rts   
1670 D834
1671 D834                       ENDP 
1672 D834
1673 D834              ; set up cdatabptr and lock the table
1674 D834
1675 D834                       EXPORT setuptab
1676 D834              setuptab PROC 
1677 D834
1678 D834 AD 86 1D              lda   |CDATabHndl+2
1679 D837 48                    pha   
1680 D838 85 3E                 sta   temp1+2
1681 D83A AD 84 1D              lda   |CDATabHndl
1682 D83D 48                    pha   
1683 D83E 85 3C                 sta   temp1
1684 D840 A2 02 20 22           _HLock 
1685 D847 20 97 D8              jsr   deref
1686 D84A A5 40                 lda   temp2
1687 D84C 8D A8 1D              sta   |cdatabptr
1688 D84F A5 42                 lda   temp2+2
1689 D851 8D AA 1D              sta   |cdatabptr+2
1690 D854
1691 D854 60                    rts   
1692 D855                       ENDP 
1693 D855
1694 D855              **********************************************************************
1695 D855                       EXPORT openda
1696 D855              openda   PROC 
1697 D855
1698 D855 78                    sei   
1699 D856 A8                    tay   
1700 D857 E2 30                 shortmx 
1701 D859 A9 FF                 lda   #$FF
1702 D85B 85 32                 sta   $000032                  ; clear the inverse flag
1703 D85D C2 30                 longmx 
1704 D85F
1705 D85F AD A8 1D              lda   |cdatabptr               ; copy the table pointer into
1706 D862 85 40                 sta   temp2                    ; the direct page
1707 D864 AD AA 1D              lda   |cdatabptr+2
1708 D867 85 42                 sta   temp2+2
1709 D869 98                    tya   
1710 D86A 3A                    dec   a
1711 D86B 0A                    asl   a                        ; adjust y
1712 D86C 0A                    asl   a
1713 D86D A8                    tay   
1714 D86E B7 40                 lda   [temp2],y                ; get a handle to the da
1715 D870 85 3C                 sta   temp1
1716 D872 C8                    iny   
1717 D873 C8                    iny   
1718 D874 B7 40                 lda   [temp2],y
1719 D876 85 3E                 sta   temp1+2
1720 D878 20 97 D8              jsr   deref                    ; deref the handle
1721 D87B A7 40                 lda   [temp2]                  ; get the length
1722 D87D 29 FF 00              and   #$00FF
1723 D880 A8                    tay   
1724 D881 C8                    iny   
1725 D882 4B                    phk                            ; set up return address
1726 D883 62 0F 00              per   ret-1
1727 D886 B7 40                 lda   [temp2],y                ; get low part of open addr
1728 D888 AA                    tax                            ; save
1729 D889 C8                    iny   
1730 D88A C8                    iny   
1731 D88B B7 40                 lda   [temp2],y                ; get high part
1732 D88D E2 20                 sep   #$20                     ; 8-bit m
1733 D88F 48                    pha                            ; push bank info
1734 D890 C2 30                 rep   #$30
1735 D892 CA                    dex   
1736 D893 DA                    phx                            ; push open address
1737 D894
1738 D894 58                    cli                            ; enable interrupts for the da
1739 D895 6B                    rtl                            ; call the routine
1740 D896 60           ret      rts                            ; all done
1741 D897
1742 D897                       ENDP 
1743 D897
1744 D897                       EXPORT deref
1745 D897              deref    PROC 
1746 D897 A0 02 00              ldy   #$02
1747 D89A A7 3C                 lda   [temp1]
1748 D89C 85 40                 sta   temp2
1749 D89E B7 3C                 lda   [temp1],y
1750 D8A0 85 42                 sta   temp2+2
1751 D8A2 60                    rts   
1752 D8A3                       ENDP 
1753 D8A3
1754 D8A3                       END   
